% Section 2.4.2 Motivation Example
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System matrices
A = [24   12; -4.4379    2.2189]; 
B = [1; 0]; 
F = B; 
D = [1;1];
C = [1 0];

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);


% Design controller & observer gains
[K,gamma_c] = Controller_design(A,B,D)
[L,gamma_e] = Observer_design(A,F,C,D)

% Closed-loop simulation
% Define global variables to store data
global tmp count ts ex1 ex2 ef ff
tmp = 0; count = 0; ts = []; ex1 = []; ex2 = []; ef = []; ff = [];

% Simulation time 
t0 = 0;
tf = 30;
tspan = [t0 tf];

% Initial conditon
x0 = [0.1 0];
hat_Xf0 = zeros(1,n+q);
xx0 = [x0 hat_Xf0];

% Uncertainty
% Case 1 - Baseline control u=Kx with Delta_A=0.1A, results in Fig.2.7
% Mc = eye(n);
% Nc = 0.1*A;
% Delta_A = Mc*Nc;

% Case 2 - FE-based FTC with Delta_A=0, results in Fig.2.8 and Fig.2.9
% Mc = 0*eye(n);
% Nc = 0*0.018*A;
% Delta_A = 0*Mc*Nc;

% Case 3 - FE-based FTC with Delta_A=0.018A, results in Fig.2.10 and Fig.2.11
Mc = eye(n);
Nc = 0.018*A;
Delta_A = Mc*Nc;


% Solve differential equation
[tt,sys] = ode45(@(t,xx) Closed_sys_performance(t,xx,A,Delta_A,B,F,D,C,K,L), tspan, xx0);
x1 = sys(:,1);
x2 = sys(:,2);
hat_f = sys(:,5);


% Draw figures
run('Draw_figures.m');
